% 2019-02-05
% "Publicly funded cultural institutions  a comparative economic valuation study"
%     Authors: Aleksandra Winiewska, Wiktor Budziski, Mikoaj Czajkowski

%     This code calculates welfare measures based on count data models
%     which are reported in the article in Table 3
        % Note, in Table 3 welfare measures are in EUR, whereas here we
        % calculate them in PLN

% INPUT: 
    % ChoiceTheatreResults.mat - results of MNL model for theatre choice (can be generated using Choice_Model_theatre.m)
    % ChoiceCinemaResults.mat - results of MNL model for cinema choice (can be generated using Choice_Model_cinema.m)
    % ChoiceMuseumResults.mat - results of MNL model for museum choice (can be generated using Choice_Model_museum.m)
    % CountTheatreResults.mat - results of NBP model for theatre attendance (can be generated using Count_Model_theatre.m)
    % CountCinemaResults.mat - results of NBP model for cinema attendance (can be generated using Count_Model_cinema.m)
    % CountMuseumResults.mat - results of NBP model for museum attendance (can be generated using Count_Model_museum.m)
    % ConsumerSurplus_count.m - function used to calculate consumer surplus
    
% OUTPUT: 
    % Excel spreadsheet Welfare_measures.xls with the results
clear
clc

%% Calculations for theatre    
load('CountTheatreResults.mat');
Results2 = Results;
load('ChoiceTheatreResults.mat');

tic
W_t1 = ConsumerSurplus_count(Results2.NBP, Results.MNL, DATA.X2, [100,0.72], []); % Welfare measures calculated for each theatre separately

Type = [5,	1;4	1;2	1;2	1;1	1;1	1;2	1;5	1;2	1;4	1;4	1;1	2;1	2;1	2;1	2;1	2;1	2;1	2;1	2;1	3;2	3;2	3;2	3;2	4;3	4;4	4;3	4;1	4;1	4;3	4;1	4; ...
    2	4;4	4;2	4;2	4;1	4;4	4;1	4;2	4;1	4;2	4;2	4;2	5;2	5];
Indx  = [1;13;25;26;14;27;2;28;15;16;29;3;4;30;31;21;5;6;32;33;34;35;7;17;8;22;36;23;18;37;38;19;39;9;40;20;10;11;41;44;45;12;24;42;43];
Type = Type(Indx(2:end)-1,:);
Type = Type([1:36, 38:44],:);

% Calculating general measure for public theatres
Type(Type(:,2)==4,2) = 3;
Type(Type(:,2)==5,2) = 3;

W_t2 = ConsumerSurplus_count(Results2.NBP, Results.MNL, DATA.X2, [100,0.72], Type(:,2)); % Welfare measures calculated for each type of theatre ownership (Public, Private, NGO)

%% Calculations for cinema

load('CountCinemaResults.mat');
Results2 = Results;
load('ChoiceCinemaResults.mat');

W_c1 = ConsumerSurplus_count(Results2.NBP, Results.MNL, DATA.X2, [100,1.26], []); % Welfare measures calculated for each cinema separately

Type = [1	1;2	1;2	2;2	2;2	2;2	2;2	2;2	2;2	1;1	1;2	1;1	1;2	1;2	1;3	1;1	1;2	2;2	2;2	2;2	2;2	1;2	1;3	1;1	1;1	1;1	1];
Type = Type([1:12, 14:22, 24:26],:);
Type_c = Type;

W_c2 = ConsumerSurplus_count(Results2.NBP, Results.MNL, DATA.X2, [100,1.26], Type(:,1)); % Welfare measures calculated for each type of cinema ownership (Public, Private, NGO)

%% Calculations for museum

load('CountMuseumResults.mat');
Results2 = Results;
load('ChoiceMuseumResults.mat');

W_m1 = ConsumerSurplus_count(Results2.NBP, Results.MNL, DATA.X2, [100,1.85], []); % Oglne teatry

Type = [1	1;1	3;1	1;1	4;1	3;1	3;1	3;1	3;1	3;1	2;1	4;2	3;1	3;1	2;1	2;1	3;1	4;1	2;1	2;1	1;1	2;1	3;1	2;1	1;2	3;1	1;1	1;1	2;1	2];
Type = Type([1:12, 14:29],:);
Type_m = Type;

W_m2 = ConsumerSurplus_count(Results2.NBP, Results.MNL, DATA.X2, [100,1.85], Type(:,1)); % Welfare measures calculated for each type of museum ownership (Public, NGO)

%% Saving results

Table_t = cell(6,2);
Table_t(1,2) = {'Consumer surplus - theatre'};
Table_t([2:4 6],1) = {'NGO';	'Private';	'Public'; 'Total Consumer surplus'};

Table_t(6,2) = {[num2str(W_t2.CS_tot(1,1), '%8.4f'), '          (', num2str(W_t2.CS_tot(1,2), '%8.4f'), ')']};

for i = 1:3
    Table_t(i+1,2) = {[num2str(W_t2.CS_change_tot(i,1), '%8.4f'), '          (', num2str(W_t2.CS_change_tot(i,2), '%8.4f'), ')']};
end

Table_c = cell(6,2);
Table_c(1,2) = {'Consumer surplus - cinema'};
Table_c([2:4 6],1) = {'Public';	'Private';	'NGO'; 'Total Consumer surplus'};
Table_c(6,2) = {[num2str(W_c2.CS_tot(1,1), '%8.4f'), '          (', num2str(W_c2.CS_tot(1,2), '%8.4f'), ')']};
for i = 1:3
    Table_c(i+1,2) = {[num2str(W_c2.CS_change_tot(i,1), '%8.4f'), '          (', num2str(W_c2.CS_change_tot(i,2), '%8.4f'), ')']};
end

Table_m = cell(5,2);
Table_m(1,2) = {'Consumer surplus - museum'};
Table_m([2:3 5],1) = {'Public';	'NGO'; 'Total Consumer surplus'};
Table_m(5,2) = {[num2str(W_m2.CS_tot(1,1), '%8.4f'), '          (', num2str(W_m2.CS_tot(1,2), '%8.4f'), ')']};
for i = 1:2
     Table_m(i+1,2) = {[num2str(W_m2.CS_change_tot(i,1), '%8.4f'), '          (', num2str(W_m2.CS_change_tot(i,2), '%8.4f'), ')']};
end

Table_t2 = cell(43,2);
Table_t2(:,1) = {'6. Pitro';'Ateneum';'Baj';'Capitol';'Dramatyczny';'Druga Strefa';'Guliwer';'IMKA';'Kamienica';'Komedia';'Komuna';'Konsekwentny';'Kwadrat';'Lalka'; ...
   'Jana Kiepury';'Myn';'Montownia';'Muzyczny Roma';'Na Woli';'Nowy';'Ochoty';'OCH-Teatr';'Palladium';'Polonia';'Polski';'Powszechny';'Praga';'Projekt Teatr';'Rampa';'Rozmaitoci'; ...
   'Sabat';'Scena Prezentacje';'Scena Wspczesna';'Studio';'Studio Buffo';'Studio Teatralne Koo';'Syrena';'Teatr Narodowy';'Teatr Wielki';'Teatr Niemoliwy';'Opera Kameralna'; ...
   'Wspczesny'; 'ydowski'};
for i = 1:43
    Table_t2(i,2) = {[num2str(W_t1.CS_change_tot(i,1), '%8.4f'), '          (', num2str(W_t1.CS_change_tot(i,2), '%8.4f'), ')']};
end

Table_c2 = cell(24,2);
Table_c2(:,1) = {'Alchemia';'Atlantic';'Cinema City Arkadia';'Cinema City Bemowo';'Cinema City Janki';'Cinema City Mokotw';'Cinema City Promenada';'Cinema City Sadyba';'Femina'; ...
    'Iluzjon';'KC';'Lab';'Kinoteka';'Kultura';'Luna';'Multikinokino Targwek';'Multikinokino Ursynw';'Multikinokino Zote Tarasy';'Multikinokino Wola Park';'Muranw';'Praha'; ...
    'Dom Kultury "wit"';'Ursus'; ' Wisa'};
for i = 1:24
    Table_c2(i,2) = {[num2str(W_c1.CS_change_tot(i,1), '%8.4f'), '          (', num2str(W_c1.CS_change_tot(i,2), '%8.4f'), ')']};
end

Table_m2 = cell(28,2);
Table_m2(:,1) = {'Centrum Nauki Kopernik';'Dom Spotka z Histori';'Kolejnictwa';'Azji i Pacyfiku';'Fryderyka Chopina';'Historii Polski';'Historii ydw Polskich';'Historyczne m.st. Warszawy';'Jana Pawa II i Prymasa Wyszyskiego'; ...
    'Literatury';'owiectwa i Jedziectwa';'Marii Sklodowskiej Curie';'Narodowe w Warszawie';'Paac w Wilanowie';'Powstania Warszawskiego';'Sportu i Turystyki';'MSN';'Teatralne';'Techniki';'azienki Krlewskie'; ...
    'Wojska Polskiego';'CSW';'Ziemi PAN';'IH';'Pastwowe Muzeum Archeologiczne';'Pastwowe Muzeum Etnograficzne';'Zachta'; 'Zamek Krlewski'};
for i = 1:28
    Table_m2(i,2) = {[num2str(W_m1.CS_change_tot(i,1), '%8.4f'), '          (', num2str(W_m1.CS_change_tot(i,2), '%8.4f'), ')']};
end

xlswrite('Welfare_measures.xls', Table_t, 'Welfare', 'A1');
xlswrite('Welfare_measures.xls', Table_c, 'Welfare', 'F1');
xlswrite('Welfare_measures.xls', Table_m, 'Welfare', 'K1');

xlswrite('Welfare_measures.xls', Table_t2, 'Welfare', 'A11');
xlswrite('Welfare_measures.xls', Table_c2, 'Welfare', 'F11');
xlswrite('Welfare_measures.xls', Table_m2, 'Welfare', 'K11');

toc